﻿namespace Hims.Shared.UserModels.Queue
{
    using System.Collections.Generic;

    /// <summary>
    /// The doctor model
    /// </summary>
    public class DoctorModel
    {
        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string SpecializationNames { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail URL.
        /// </summary>
        /// <value>
        /// The thumbnail URL.
        /// </value>
        public string ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patients.
        /// </summary>
        /// <value>
        /// The patients.
        /// </value>
        public List<PatientModel> Patients { get; set; }

        /// <summary>
        /// Gets or sets the name of the room.
        /// </summary>
        /// <value>
        /// The name of the room.
        /// </value>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the name of the floor.
        /// </summary>
        /// <value>
        /// The name of the floor.
        /// </value>
        public string FloorName { get; set; }

        /// <summary>
        /// Gets or sets the specialization.
        /// </summary>
        /// <value>
        /// The specialization.
        /// </value>
        public string? Specialization { get; set; }

        /// <summary>
        /// Gets or sets the specializations.
        /// </summary>
        /// <value>
        /// The specializations.
        /// </value>
        public int[]? Specializations { get; set; }
    }
}
