﻿
using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class NeonatalIPEncounter
    {
        /// <summary>
        /// Gets or Sets the Neonatal IP Encounter
        /// </summary>
        [Key, Identity]
        public int NeonatalIPEncounterId { get; set; }
        /// <summary>
        /// Gets or Sets the appointment id
        /// </summary>
        public int? AppointmentId { get; set; }
        /// <summary>
        /// Gets or Sets the patient id
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or Sets the pediatric encounter date
        /// </summary>
        public DateTime NeonatalIPEncounterDate { get; set; }
        /// <summary>
        /// Gets or Sets the active
        /// </summary>
        /// 
        public bool Active { get; set; }
        /// <summary>
        /// Gets or Sets the created by
        /// </summary>

        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or Sets the created date
        /// </summary>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or Sets the modified by
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or Sets the modified date
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or Sets the admission id
        /// </summary>
        public int? AdmissionId { get; set; }
        /// <summary>
        /// Gets or Sets the 
        /// </summary>
        public string NeonatalBaby { get; set; }

    }

}

