﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The visit type.
    /// </summary>
    public class ProviderScheduleCharge
    {
        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        [Key, Identity]
        public int? ProviderScheduleChargeId { get; set; }

        /// <summary>
        /// Gets or sets the visitor name.
        /// </summary>
        public int SpecializationId { get; set; }


        /// <summary>
        /// Gets or sets the visit type for.
        /// </summary>
        public decimal SpecializationCharge { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the charge type charge.
        /// </summary>
        public string? ChargeTypeCharge { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the visit type duration.
        /// </summary>
        public string? VisitTypeDuration { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

    }
}
