﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.OperationTheater;
    using Shared.EntityModels;
    using Shared.UserModels;

    /// <summary>
    /// The id proof Service interface.
    /// </summary>
    public interface IOTRegisterService
    { 
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
    Task<int> InsertAsync(OTRegisterInsertModel model);
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> CancelAsync(OTRegisterInsertModel model);

        /// <summary>
        /// reschedule the appointment.
        /// </summary>
        /// <param name="otRegisterId">The model.</param>
        /// <param name="modifiedBy">Modified By Name.</param>
        /// <param name="appointmentDate">Appointment Date.</param>
        /// <param name="appointmentTime">Appointment Start Time.</param>
        /// <param name="appointmentEndTime">Appointment End Time.</param>
        /// <returns></returns>
        Task<int> RescheduleAsync(int otRegisterId, int modifiedBy, DateTime appointmentDate, DateTime appointmentEndTime, int scanMachineMasterId);
        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<OTRegisterFilterModel>> FetchAllAsync(OTRegisterFilterModel model);
       
        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
       
        Task<string> FetchAltAsync(int Id);
        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(OTRegisterInsertModel model);

       
        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateTest(OTRegisterInsertModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="ScanMachineAvailabilityId">
        /// The scan availability.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int? scanMachineAvailabilityId);
        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<OTRegisterFilterModel>> FetchFilterEvent(OTFilterModel model);

    }
}
