﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The lookup value.
    /// </summary>
    public class LookupValueModel
    {
        /// <summary>
        /// Gets or sets the lookup value id.
        /// </summary>
        public int LookupValueId { get; set; }
        
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the lookup id.
        /// </summary>
        public int LookupId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the totalItems.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the type of.
        /// </summary>
        public string TypeOf { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public string? AccountFullName { get; set; }

        /// <summary>
        /// Gets or sets the type name.
        /// </summary>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the Pharmacy Log type.
        /// </summary>
        public int PharmacyLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacyLog code.
        /// </summary>
        public string LogDescription { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Pharmacy Log type.
        /// </summary>
        public int LabLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }
        /// <summary>
        /// Gets or sets the lookupValueName .
        /// </summary>
        public string? LookupValueName { get; set; }
        /// <summary>
        /// Gets or sets the lookupValueName .
        /// </summary>
        public string? FromDate { get; set; }
        /// <summary>
        /// Gets or sets the lookupValueName .
        /// </summary>
        public string? ToDate { get; set; }
        // <summary>
        /// Gets or sets the created by role.
        /// </summary>
        public string? CreatedByRole { get; set; }

        // <summary>
        /// Gets or sets the created by role.
        /// </summary>
        public string? ModifiedByRole { get; set; }


        /// <summary>
        /// Gets or sets the LocationId by.
        /// </summary>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the Category Name
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the Unit Name
        /// </summary>
        public string? UnitName { get; set; }
    }
}
