﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class ObEncounterFullTranscriptModel
    {
        /// <summary>
        /// Gets or sets the gyn encounter id.
        /// </summary>
        public int ObEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        public DateTime EncounterDate { get; set; }



        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the educations.
        /// </summary>
        public string? Educations { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the provider no.
        /// </summary>
        public string? ProviderNo { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string? SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string? PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the practice location.
        /// </summary>
        public string? PracticeLocation { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string? Signature { get; set; }

        /// <summary>
        /// Gets or sets the clinic picture.
        /// </summary>
        public string? ClinicPicture { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }
        /// <summary>
        /// Gets or sets the patient umrNo.
        /// </summary>
        public string PatientNo { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }


        /// <summary>
        /// Gets or sets the problem list.
        /// </summary>
        public string? ProblemList { get; set; }

        /// <summary>
        /// Gets or sets the brief ros.
        /// </summary>
        public string? BriefRos { get; set; }

        /// <summary>
        /// Gets or sets the genetic  screening.
        /// </summary>
        public string? GeneticScreening { get; set; }

        /// <summary>
        /// Gets or sets the infection history.
        /// </summary>
        public string? InfectionHistory { get; set; }

        /// <summary>
        /// Gets or sets the complaints.
        /// </summary>
        public string? Complaints { get; set; }
        /// <summary>
        /// Gets or sets the obstetric examination.
        /// </summary>
        public string? ObstetricExamination { get; set; }

        /// <summary>
        /// Gets or sets the breast examination.
        /// </summary>
        public string? BreastExamination { get; set; }


        /// <summary>
        /// Gets or sets the vaginal examination.
        /// </summary>
        public string? VaginalExamination { get; set; }

        /// <summary>
        /// Gets or sets the anc cared closure.
        /// </summary>
        public string? ANCCaredClosure { get; set; }

        /// <summary>
        /// Gets or sets the anc cared generation.
        /// </summary>
        public string? ANCCardGeneration { get; set; }

        /// <summary>
        /// Gets or sets the plan of management.
        /// </summary>
        public string? PlanOfManagement { get; set; }
        /// <summary>
        /// Gets or sets the order prescription.
        /// </summary>
        public string? OrderPriscription { get; set; }
        
        /// <summary>
        /// Gets or sets the vte risk.
        /// </summary>
        public string? VTERisk { get; set; }
        
        /// <summary>
        /// Gets or sets the birth history.
        /// </summary>
        public string? BirthHistory { get; set; }
        
        /// <summary>
        /// Gets or sets the procedure form.
        /// </summary>
        public string? ProcedureForm { get; set; }
        
        /// <summary>
        /// Gets or sets the sga scanning.
        /// </summary>
        public string? SGAScanning { get; set; }

        /// <summary>
        /// Gets or sets the surgeries.
        /// </summary>
        public string? Surgeries { get; set; }
        
        /// <summary>
        /// Gets or sets the order prescription.
        /// </summary>
        public string? OrderPrescription { get; set; }
        
        /// <summary>
        /// Gets or sets the drug history.
        /// </summary>
        public string? DrugHistory { get; set; }

        /// <summary>
        /// Gets or sets the menstrual history.
        /// </summary>
        public string? MenstrualHistory { get; set; }

        /// <summary>
        /// Gets or sets the antinantal risk.
        /// </summary>
        public string? AntinantalRisk { get; set; }
        /// <summary>
        /// Gets or sets the other detail.
        /// </summary>
        public string? OtherDetail { get; set; }
        /// <summary>
        /// Gets or sets the measure
        /// </summary>
        public string? Measure { get; set; }
        /// <summary>
        /// Gets or sets the general examination
        /// </summary>
        public string? GeneralExamination { get; set; }
        /// <summary>
        /// Gets or sets the breech
        /// </summary>
        public string? Breech { get; set; }

        /// <summary>
        /// Gets or sets the anc card.
        /// </summary>
        public string? AncCard { get; set; }
        /// <summary>
        /// Gets or sets the covid.
        /// </summary>
        public string? Covid { get; set; }
        /// <summary>
        /// Gets or sets the postnantalVisit
        /// </summary>
        public string? PostnantalVisit { get; set; }
        /// <summary>
        /// Gets or sets the vaccine
        /// </summary>
        public string? Vaccine { get; set; }
        /// <summary>
        /// Get or sets anaesthesia record
        /// </summary>
        public string? AnaesthesiaRecord { get; set; }
        /// <summary>
        /// Get or sets pre pregnancy counseling
        /// </summary>
        public string? PrepregnancyCounseling { get; set; }
        /// <summary>
        /// Get or sets name of Partner.
        /// </summary>
        public string Partner { get; set; }
        /// <summary>
        /// Get or sets name of Partner.
        /// </summary>
        public string FriendlyName { get; set; }
        /// <summary>
        /// Get or sets name of Partner.
        /// </summary>
        public string Email { get; set; }
        /// <summary>
        /// Get or sets allergies.
        /// </summary>
        public string? Allergies { get; set; }

        /// <summary>
        /// Get or sets pre pregnancy plan
        /// </summary>
        public string? PrePregnancyPlan { get; set; }
        /// <summary>
        /// Get or sets special features
        /// </summary>
        public string? SpecialFeature { get; set; }
        /// <summary>
        /// Get or sets referral form
        /// </summary>
        public string? ReferralForm { get; set; }
        /// <summary>
        /// Gets or sets out patient management
        /// </summary>
        public string? OutPatientManagement { get; set; }
        /// <summary>
        /// Gets or sets out patient management
        /// </summary>
        public string? ScanAppointmentDetails { get; set; }
            /// <summary>
            /// Gets or sets famli history
            /// </summary>
        public string? FamilyHistory { get; set; }
        /// <summary>
        /// Gets or sets out side tests
        /// </summary>
        public string? OutSideTests { get; set; }

        /// <summary>
        /// Gets or sets out side tests
        /// </summary>
        public string? AdmissionSlip { get; set; }

        /// <summary>
        /// Gets or sets out side tests
        /// </summary>
        public string? RefferalOrder { get; set; }
        /// <summary>
        /// Gets or sets out side tests
        /// </summary>
        public string? Reminder { get; set; }



    }
}