﻿namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The transaction detail.
    /// </summary>
    public class SettlementDetailModel
    {
        /// <summary>
        /// Gets or sets the txn id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the batch id.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the merchant ref id.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the noOfAppointments.
        /// </summary>
        public string NoOfAppointments { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? Amount { get; set; }

        /// <summary>
        /// Gets or sets the txn Discount.
        /// </summary>
        public string Discount { get; set; }

        // public DateTime Total { get; set; }

        /// <summary>
        /// Gets or sets the ProviderPercentage
        /// </summary>
        public decimal ProviderPercentage { get; set; }

        /// <summary>
        /// Gets or sets the TDSAmount
        /// </summary>
        public decimal TDSAmount { get; set; }

        /// <summary>
        /// Gets or sets the AppCharges.
        /// </summary>
        public decimal AppCharges { get; set; }

        /// <summary>
        /// Gets or sets the SettledAmount
        /// </summary>
        public decimal SetteledAmount { get; set; }

        /// <summary>
        /// Gets or sets the payout.
        /// </summary>
        public decimal Payout { get; set; }

        /// <summary>
        /// Gets or sets the setteled by payout.
        /// </summary>
        public decimal SetteledByPayout { get; set; }

        /// <summary>
        /// Gets or sets the refund.
        /// </summary>
        public decimal Refund { get; set; }

        /// <summary>
        /// Gets or sets the money settled.
        /// </summary>
        public decimal MoneySettled { get; set; }

        /// <summary>
        /// Gets or sets the money with payu.
        /// </summary>
        public decimal MoneyWithPayU { get; set; }

        /// <summary>
        /// Gets or sets the TotalItems
        /// </summary>
        public long TotalItems { get; set; }
    }
}