﻿namespace Hims.Shared.UserModels.Inventory
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The inventory ware house model.
    /// </summary>
    public class InventoryWareHouseModel
    {
        /// <summary>
        /// Gets or sets the inventory ware house identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house identifier.
        /// </value>
        public int InventoryWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the allowed account identifier.
        /// </summary>
        /// <value>
        /// The allowed account identifier.
        /// </value>
        public string AllowedAccountId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="InventoryWareHouseModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }


        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the users.
        /// </summary>
        /// <value>
        /// The users.
        /// </value>
        public List<InventoryWareHouseUserModel> Users { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the account based access identifier.
        /// </summary>
        /// <value>
        /// The account based access identifier.
        /// </value>
        public int? AccountBasedAccessId { get; set; }
    }

    /// <summary>
    /// The inventory ware house user.
    /// </summary>
    public class InventoryWareHouseUserModel
    {
        /// <summary>
        /// Gets or sets the inventory ware house user identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house user identifier.
        /// </value>
        public int InventoryWareHouseUserId { get; set; }

        /// <summary>
        /// Gets or sets the inventory ware house identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house identifier.
        /// </value>
        public int InventoryWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the account identifier.
        /// </summary>
        /// <value>
        /// The account identifier.
        /// </value>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }
    }
}
