﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.Menu.Relationship
{
    /// <summary> The chat.</summary>
    public class UpdateModel
    {
        /// <summary>
        /// Gets or sets the menu identifier.
        /// </summary>
        /// <value>
        /// The menu identifier.
        /// </value>
        public int? InitialMenuId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is full access.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is full access; otherwise, <c>false</c>.
        /// </value>
        public bool IsFullAccess { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the added.
        /// </summary>
        /// <value>
        /// The added.
        /// </value>
        public List<int> Added { get; set; }

        /// <summary>
        /// Gets or sets the removed.
        /// </summary>
        /// <value>
        /// The removed.
        /// </value>
        public List<int> Removed { get; set; }

        /// <summary>
        /// Gets or sets the added.
        /// </summary>
        /// <value>
        /// The added.
        /// </value>
        public List<int> MenuButtonsAdded { get; set; }

        /// <summary>
        /// Gets or sets the removed.
        /// </summary>
        /// <value>
        /// The removed.
        /// </value>
        public List<int> MenuButtonsRemoved { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the account fullName .
        /// </summary>
        public string? ModifiedByName { get; set; }

    }
}