﻿namespace Hims.Shared.UserModels.ProviderMedication
{
    using System.Collections.Generic;


    /// <summary>
    /// The provider medication master model.
    /// </summary>
    public class ProviderMedicationMasterModel
    {
        /// <summary>
        /// Gets or sets the provider medication master identifier.
        /// </summary>
        /// <value>
        /// The provider medication master identifier.
        /// </value>
        public int? ProviderMedicationMasterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the provider medication group identifier.
        /// </summary>
        /// <value>
        /// The provider medication group identifier.
        /// </value>
        public int? ProviderMedicationGroupId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        /// <value>
        /// The duration.
        /// </value>
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the dosage.
        /// </summary>
        /// <value>
        /// The dosage.
        /// </value>
        public int Dosage { get; set; }

        /// <summary>
        /// Gets or sets the type of the duration.
        /// </summary>
        /// <value>
        /// The type of the duration.
        /// </value>
        public string DurationType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is morning.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is morning; otherwise, <c>false</c>.
        /// </value>
        public bool IsMorning { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is afternoon.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is afternoon; otherwise, <c>false</c>.
        /// </value>
        public bool IsAfternoon { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is night.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is night; otherwise, <c>false</c>.
        /// </value>
        public bool IsNight { get; set; }

        /// <summary>
        /// Gets or sets the morning dosage.
        /// </summary>
        /// <value>
        /// The morning dosage.
        /// </value>
        public string MorningDosage { get; set; }

        /// <summary>
        /// Gets or sets the afternoon dosage.
        /// </summary>
        /// <value>
        /// The afternoon dosage.
        /// </value>
        public string AfternoonDosage { get; set; }

        /// <summary>
        /// Gets or sets the night dosage.
        /// </summary>
        /// <value>
        /// The night dosage.
        /// </value>
        public string NightDosage { get; set; }

        /// <summary>
        /// Gets or sets the instruction.
        /// </summary>
        /// <value>
        /// The instruction.
        /// </value>
        public string Instruction { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the company identifier.
        /// </summary>
        /// <value>
        /// The company identifier.
        /// </value>
        public int CompanyId { get; set; }

        /// <summary>
        /// Gets or sets the category identifier.
        /// </summary>
        /// <value>
        /// The category identifier.
        /// </value>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the tag.
        /// </summary>
        /// <value>
        /// The name of the tag.
        /// </value>
        public string TagName { get; set; }

        /// <summary>
        /// Gets or sets the name of the specialization.
        /// </summary>
        /// <value>
        /// The name of the specialization.
        /// </value>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the specialization identifier.
        /// </summary>
        /// <value>
        /// The specialization identifier.
        /// </value>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the providers.
        /// </summary>
        /// <value>
        /// The providers.
        /// </value>
        public List<ProviderList> Providers { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or Sets the modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

    }

    /// <summary>
    /// The provider list.
    /// </summary>
    public class ProviderList
    {
        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }
    }
}
