﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.UserModels
{
    public class RelationsModel
    {
        /// <summary>
        /// Gets or sets the RelationsId.
        /// </summary>

        [Key]
        public int? RelationsId { get; set; }

        /// <summary>
        /// Gets or sets the RelationsName.
        /// </summary>
        public string RelationName { get; set; }

        /// <summary>
        /// Gets or sets the RO.
        /// </summary>
        public string RO { get; set; }
        /// <summary>
        /// Gets or sets the Status.
        /// </summary>
        public bool? Active { get; set; }
        /// <summary>
        /// Gets or sets id of creator.
        /// </summary>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets id of modifier.
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets date of creation.
        /// </summary>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets date of modification.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets id of login role.
        /// </summary>
        public int LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets name of creator.
        /// </summary>
        public String CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets name of modifier.
        /// </summary>
        public String? ModifiedByName { get; set;}
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int? TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }
    }
}
