﻿namespace Hims.Domain.Entities
{
    using Shared.Dapper.Attributes;

    using System;
    using System.ComponentModel.DataAnnotations;

    public class LeaveType
    {
        /// <summary>
        /// Gets or sets the leave type id.
        /// </summary>
        [Key, Identity]
        public int LeaveTypeId { get; set; }

        /// <summary>
        /// Gets or sets the lave type name.
        /// </summary>
        public string LeaveTypeName { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the no of days.
        /// </summary>
        public int NoOfDays { get; set; }

        /// <summary>
        /// Gets or sets the note.
        /// </summary>
        public string Note { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }
    }
}
