﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The sale return header.
    /// </summary>
    public class SaleReturnHeader
    {
        /// <summary>
        /// Gets or sets the sale return header id.
        /// </summary>
        [Key, Identity]
        public int SaleReturnHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the return date.
        /// </summary>
        public DateTime ReturnDate { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy sale header id.
        /// </summary>
        public int PharmacySaleHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double OverallTotal { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the overall taxes.
        /// </summary>
        public double OverallTaxes { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
