﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.UserModels;

namespace Hims.Infrastructure.Services
{
    /// <summary>
    /// The unit of work.
    /// </summary>
    // <summary>
    /// The unit of work.
    /// </summary>


    /// <inheritdoc cref="IIdProofService" />


    public class RelationsService : IRelationsService
    {

        private readonly IUnitOfWork unitOfWork;
        /// <inheritdoc cref="IChatService" />
        public RelationsService(IUnitOfWork unitOfWork) { this.unitOfWork = unitOfWork; }


        public async Task<IEnumerable<RelationsModel>> FetchAllAsync(RelationsModel model)
        {

            var query = $@"select count(ID.""RelationsId"") over() as ""TotalItems"", ID.""RelationsId"", ID.""RelationName"", ID.""RO"", ID.""Active"", ID.""CreatedBy"", ID.""CreatedDate"",
		                        ID.""ModifiedBy"", ID.""ModifiedDate"",
		                        C.""FullName"" as ""CreatedByName"", CR.""RoleName"" as ""CreatedByRole"",M.""FullName"" as ""ModifiedByName"", MR.""RoleName"" as ""ModifiedByRole""
                             FROM ""Relations"" ID 
                             join ""Account"" C on C.""AccountId"" = ID.""CreatedBy""
                             join ""Role"" CR on CR.""RoleId"" = C.""RoleId""
                             left join ""Account"" M on M.""AccountId"" = ID.""ModifiedBy""
                             left join ""Role"" MR on MR.""RoleId"" = M.""RoleId""
                               
                             order by ID.""CreatedDate"" desc";
            if (model.PageIndex != null && model.PageSize != null)
            {
                model.PageIndex = model.PageIndex > 0 ? model.PageIndex - 1 : model.PageIndex;
                query += $@" limit {model.PageSize} offset {model.PageSize * model.PageIndex}";
            }


            var record = await this.unitOfWork.Current.QueryAsync<RelationsModel>(query);

            return record;

        }

        public async Task<int> UpdateAsync(RelationsModel model)

        {
            { 
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""Relations"" where  lower (""RelationName"") = '{model.RelationName.ToLower()}' and ""RelationsId"" <> {model.RelationsId}");
            if (checkIf > 0)
            {
                return -1;
            }
            var record = await this.unitOfWork.Relations.FindAsync(m => m.RelationsId == model.RelationsId);
            if (record == null)
            {
                return -2;
            }
            record.ModifiedBy = model.CreatedBy;
            record.ModifiedDate = DateTime.Now;
            record.RelationName = model.RelationName;
            record.RO=model.RO;
            return await this.unitOfWork.Relations.UpdateAsync(record);
        }
           
            return 1;
        }



        
        public async Task<int> ActivateOrDeactivateTest(RelationsModel model)
        {
            var query = $@"UPDATE ""Relations""
	                           SET ""ModifiedBy""={model.CreatedBy}, ""ModifiedDate""=now(), ""Active""= {model.Active}
	                           WHERE ""RelationsId""= {model.RelationsId}";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }

        public async  Task<int> InsertAsync(RelationsModel model)
        {
           
     
                var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""Relations"" where  lower(""RelationName"") = '{model.RelationName.ToLower()}'");
                if (checkIf > 0)
                {
                    return -1;
                }
                var relation = new Relations
                {
                    RelationName = model.RelationName,
                    RO=model.RO,
                    CreatedBy = model.CreatedBy,
                    Active = true,
                    CreatedDate = DateTime.Now,
                };
                return await this.unitOfWork.Relations.InsertAsync(relation);
            }
            





        }

    }
