﻿namespace Hims.Shared.UserModels.PediatricGraphs
{
    /// <summary>
    /// The pediatric chart type model.
    /// </summary>
    public class PediatricChartTypeModel
    {
        /// <summary>
        /// Gets or sets the pediatric chart type identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart type identifier.
        /// </value>
        public int PediatricChartTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="PediatricChartType"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
    }
}
