﻿namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The pharmacy purchase bill.
    /// </summary>
    public class PharmacyPurchaseBill
    {

        /// <summary>
        /// Get or sets the pharmacy purchase header id.
        /// </summary>
        public int PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Get or sets the pharmacy purchase detail id.
        /// </summary>
        public int PharmacyPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the auto generate bill number.
        /// </summary>
        public string AutoGenerateBillNumber { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public double? Free { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        public double? TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the bar code.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the supplier name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted pharmacy stock id.
        /// </summary>
        public string EncryptedPharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        public int ReturnQuantity { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int ProductId { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the role id .
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        public DateTime? DueDate { get; set; }


        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        public List<UpdatePurchaseBillModel> Bills { get; set; }


        /// <summary>
        /// Gets or sets the retail pharmacy identifier.
        /// </summary>
        /// <value>
        /// The retail pharmacy identifier.
        /// </value>
        public int? RetailPharmacyId { get; set; }
        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        public bool? IsIGST { get; set; }
        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        public bool? IsSGST { get; set; }
    }
    /// <summary>
    /// The request indent product model.
    /// </summary>
    public class UpdatePurchaseBillModel
    {
        /// <summary>
        /// Get or sets the pharmacy purchase header id.
        /// </summary>
        public int PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Get or sets the pharmacy purchase detail id.
        /// </summary>
        public int PharmacyPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the auto generate bill number.
        /// </summary>
        public string AutoGenerateBillNumber { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public double? Free { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        public double? TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the bar code.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the supplier name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted pharmacy stock id.
        /// </summary>
        public string EncryptedPharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        public int ReturnQuantity { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int ProductId { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the role id .
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

    }
}
