﻿namespace Hims.Shared.UserModels.Scan.ScanMachine
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The scan machine.
    /// </summary>
    public class ScanMachineInsertModel
    {
        /// <summary>
        /// Gets or sets the scan machine master id.
        /// </summary>
        public int ScanMachineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the machine name.
        /// </summary>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        public string DisplayName { get; set; }
        
        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }
        
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the scan machine test map id.
        /// </summary>
        public int ScanMachineTestMapId { get; set; }

        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public string ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the location ids.
        /// </summary>
        /// <value>
        /// The location ids.
        /// </value>
        public string LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the allowed account identifier.
        /// </summary>
        /// <value>
        /// The allowed account identifier.
        /// </value>
        public string PerformedTestId { get; set; }
    }

}
