﻿namespace Hims.Domain.Helpers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Microsoft.AspNetCore.Http;

    /// <summary>
    /// The Document helper interface.
    /// </summary>
    public interface IDocumentHelper
    {
        /// <summary>
        /// The get url.
        /// </summary>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="fileName">
        /// The file name.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string GetUrl(Guid guid, string fileName);

        /// <summary>
        /// The get DB url.
        /// </summary>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="fileName">
        /// The file name.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string GetDbUrl(Guid guid, string fileName);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="fileUrl">
        /// The file URL.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> DeleteAsync(Guid guid, string fileUrl);

        /// <summary>
        /// The upload async.
        /// </summary>
        /// <param name="file">
        /// The file.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder Name.
        /// </param>
        /// <param name="filName">
        /// The fil Name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadAsync(IFormFile file, Guid guid, string folderName, string filName);

        /// <summary>
        /// The upload document async.
        /// </summary>
        /// <param name="file">
        /// The file.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder name.
        /// </param>
        /// <param name="filName">
        /// The fil name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadDocumentAsync(IFormFile file, Guid guid, string folderName, string filName);

        /// <summary>
        /// The upload thumbnail async.
        /// </summary>
        /// <param name="file">
        /// The file.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder Name.
        /// </param>
        /// <param name="filName">
        /// The fil Name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadThumbnailAsync(IFormFile file, Guid guid, string folderName, string filName);

        /// <summary>
        /// The upload thumbnail async.
        /// </summary>
        /// <param name="file">
        /// The file.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder Name.
        /// </param>
        /// <param name="filName">
        /// The fil Name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadProfileImageAsync(IFormFile file, Guid guid, string folderName, string filName);

        /// <summary>
        /// The upload thumbnail async.
        /// </summary>
        /// <param name="file">
        /// The file.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder Name.
        /// </param>
        /// <param name="filName">
        /// The fil Name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadThumbnailImageAsync(IFormFile file, Guid guid, string folderName, string filName);

        /// <summary>
        /// The upload attachments async.
        /// </summary>
        /// <param name="file">
        /// The file.
        /// </param>
        /// <param name="basePath">
        /// The base path.
        /// </param>
        /// <param name="folderName">
        /// The folder name.
        /// </param>
        /// <param name="filName">
        /// The fil name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadAttachmentsAsync(IFormFile file, string basePath, string folderName, string filName);

        /// <summary>
        /// The upload attachments async.
        /// </summary>
        /// <param name="base64Image">
        /// The file.
        /// </param>
        /// <param name="basePath">
        /// The base path.
        /// </param>
        /// <param name="folderName">
        /// The folder name.
        /// </param>
        /// <param name="filName">
        /// The fil name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadImageAsync(string base64Image, string basePath, string folderName, string filName);

        /// <summary>
        /// The upload async.
        /// </summary>
        /// <param name="base64Image">
        /// The base 64 Image.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder Name.
        /// </param>
        /// <param name="filName">
        /// The fil Name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<Tuple<string, string>> UploadAsync(string base64Image, Guid guid, string folderName, string filName);
      
        /// <summary>
        /// The upload async.
        /// </summary>
        /// <param name="base64Image">
        /// The base 64 Image.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder Name.
        /// </param>
        /// <param name="filName">
        /// The fil Name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadProfileImageAsync(string base64Image, Guid guid, string folderName, string filName);

        /// <summary>
        /// The upload async.
        /// </summary>
        /// <param name="base64ThumnailImage">
        /// The base 64 Image.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder Name.
        /// </param>
        /// <param name="filName">
        /// The fil Name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadThumbnailImageAsync(string base64ThumnailImage, Guid guid, string folderName, string filName);

        /// <summary>
        /// The upload encounter images async.
        /// </summary>
        /// <param name="base64Image">
        /// The base 64 image.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <param name="folderName">
        /// The folder name.
        /// </param>
        /// <param name="filName">
        /// The fil name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> UploadEncounterImagesAsync(string base64Image, Guid guid, string folderName, string filName);

        /// <summary>
        /// The delete attachments async.
        /// </summary>
        /// <param name="fileUrl">
        /// The file url.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> DeleteAttachmentsAsync(string fileUrl);

        /// <summary>
        /// Get document thumbnail.
        /// </summary>
        /// <param name="contentType">
        /// The content type.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        string GetThumbnail(string contentType);

        /// <summary>
        /// The fetch content types.
        /// </summary>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        IEnumerable<string> FetchContentTypes();

        /// <summary>
        /// The fetch image content types.
        /// </summary>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        IEnumerable<string> FetchImageContentTypes();
    }
}