﻿namespace Hims.Domain.Helpers
{
    using Microsoft.AspNetCore.Http;
    using System;
    using System.IO;
    using System.Threading.Tasks;

    /// <summary>
    /// The FTP upload helper.
    /// </summary>
    public interface IFtpUploadHelper
    {
        /// <summary>
        /// Creates the directory.
        /// </summary>
        /// <param name="folderNameWithCompletePath">The folder name with complete path.</param>
        /// <returns></returns>
        Task<int> CreateDirectory(string folderNameWithCompletePath);

        /// <summary>
        /// Uploads the profile image asynchronous.
        /// </summary>
        /// <param name="base64Image">The base64 image.</param>
        /// <param name="filePath">The file path.</param>
        /// <returns></returns>
        Task<int> UploadProfileImageAsync(string base64Image, string filePath);

        /// <summary>
        /// Deletes the file.
        /// </summary>
        /// <param name="fileNameWithDestinationPath">The file name with destination path.</param>
        /// <returns></returns>
        Task<int> DeleteFile(string fileNameWithDestinationPath);

        /// <summary>
        /// Downloads the small files asynchronous.
        /// </summary>
        /// <param name="fileNameWithPath">The file name with path.</param>
        /// <returns></returns>
        Task<byte[]> DownloadSmallFilesAsync(string fileNameWithPath);

        /// <summary>
        /// Downloads the large file.
        /// </summary>
        /// <param name="fileNameWithPath">The file name with path.</param>
        /// <returns></returns>
        Task<Stream> DownloadLargeFile(string fileNameWithPath);

        /// <summary>
        /// Uploads the file with byte array asynchronous.
        /// </summary>
        /// <param name="fileName">Name of the file.</param>
        /// <param name="source">The source.</param>
        /// <returns></returns>
        Task<int> UploadFileWithByteArrayAsync(string fileName, byte[] source);

        /// <summary>
        /// Uploads the file with stream asynchronous.
        /// </summary>
        /// <param name="fileName">Name of the file.</param>
        /// <param name="stream">The stream.</param>
        /// <returns></returns>
        Task<int> UploadFileWithStreamAsync(string fileName, Stream stream);

        /// <summary>
        /// Uploads from file asynchronous.
        /// </summary>
        /// <param name="fileName">Name of the file.</param>
        /// <param name="fileInfo">The file information.</param>
        /// <returns></returns>
        Task<int> UploadFromFileAsync(string fileName, IFormFile fileInfo);

        /// <summary>
        /// Downloads the base64 data asynchronous.
        /// </summary>
        /// <param name="fileNameWithPath">The file name with path.</param>
        /// <returns></returns>
        Task<string> DownloadBase64DataAsync(string fileNameWithPath);

        /// <summary>
        /// Checks if file exists on server.
        /// </summary>
        /// <param name="fileName">Name of the file.</param>
        /// <returns></returns>
        bool CheckIfFileExistsOnServer(string fileName);
        Task<int> DeleteDirectory(string folder);
        Task<bool> Rename(string source, string destination);
    }
}