﻿using Hims.Shared.Library;
using Hims.Shared.UserModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    public interface IDynamicTemplateConfigService
    {

        Task<IEnumerable<Resource>> FetchTemplateConfigs(GetTemplateConfigs model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(DynamicTemplateConfigModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DynamicTemplateConfigModel>> FetchAllAsync(DynamicTemplateConfigModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        Task<IEnumerable<Resource>> FetchDynamicTemplate();
        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(DynamicTemplateConfigModel model);

        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateTest(DynamicTemplateConfigModel model);

    }
}
