﻿namespace Hims.Infrastructure.Services
{
    using Dapper;
    using Hims.Domain.Entities;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Domain.Services;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.TemplateDesign.Template;
    using System;
    using System.Collections.Generic;
    using System.Text;
    using System.Threading.Tasks;
    using System.Xml.Linq;

    public class TemplateService : ITemplateService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        public TemplateService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<int> InsertAsync(InsertModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"Select count(*) from ""template"".""Template"" where lower(""TemplateName"")='{model.TemplateName.ToLower()}'");
            if (checkIf > 0)
            {
                return -1;
            }
            var template = new Template
            {
                TemplateName = model.TemplateName,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
                Active = true
            };
            return await this.unitOfWork.Templates.InsertAsync(template);
        }
    }
}
