﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities
{
    /// <summary>
    /// The general notification model.
    /// </summary>
    public class GeneralNotification
    {
        /// <summary>
        /// Gets or sets the general notification identifier.
        /// </summary>
        /// <value>
        /// The general notification identifier.
        /// </value>
        [Key,Identity]
        public long GeneralNotificationId { get; set; }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is priority.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is priority; otherwise, <c>false</c>.
        /// </value>
        public bool IsPriority { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int ModulesMasterId { get; set; }

        /// <summary>
        /// Gets or sets the redirect URL.
        /// </summary>
        /// <value>
        /// The redirect URL.
        /// </value>
        public string RedirectUrl { get; set; }

        /// <summary>
        /// Gets or sets for roles.
        /// </summary>
        /// <value>
        /// For roles.
        /// </value>
        public string ForRoles { get; set; }

        /// <summary>
        /// Gets or sets for accounts.
        /// </summary>
        /// <value>
        /// For accounts.
        /// </value>
        public string ForAccounts { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is read.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is read; otherwise, <c>false</c>.
        /// </value>
        public bool IsRead { get; set; }

        /// <summary>
        /// Gets or sets the web notification log type identifier.
        /// </summary>
        /// <value>
        /// The web notification log type identifier.
        /// </value>
        public int WebNotificationLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the reference identifier.
        /// </summary>
        /// <value>
        /// The reference identifier.
        /// </value>
        public long? ReferenceId { get; set; }
    }
}
