﻿#nullable enable
namespace Hims.Shared.UserModels.ProviderScheduleVisits
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class ViewModel
    {

        /// <summary>
        /// Gets or sets the Provider Availability Visit Id
        /// </summary>
        public int ProviderAvailabilityVisitTypeId { get; set; }


        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int? Duration { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        public int? ProviderId { get; set; }
        public int? SpecializationId { get; set; }
        public int? LocationId { get; set; }
        public string LocationName { get; set; }
        public string VisitNames { get; set; }
        public string ProviderName { get; set; }
        public string SpecializationName { get; set; }
        public string CreatedByName { get; set; }
        public string ModifiedByName { get; set; }
        public int id { get; set; }
        public string Name { get; set; }
        public int TotalItems { get; set; }
        public int Value { get; set; }
        public string SchedulerTypeId { get; set; }
        public string FullName { get; set; }
    }
}
