﻿using System;
namespace Hims.Shared.UserModels
{
    public class ReferenceTypeModel
    {
        /// <summary>
        /// Gets or sets the ModulesMasterId.
        /// </summary>
        public int PatientReferredById { get; set; }
        /// <summary>
        /// Gets or sets the ModuleName.
        /// </summary>
        public string Name { get; set; }
        
        /// Gets or sets a value indicating whether this  is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public short? LoginRoleId { get; set; }

    }

}
