﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.ServiceOrder.Admission
{
    /// <summary> The chat.</summary>
    public class BasicViewModel
    {
        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        /// <value>
        /// The date.
        /// </value>
        public DateTime Date { get; set; }
        /// <summary>
        /// Gets or sets the bed cost.
        /// </summary>
        /// <value>
        /// The bed cost.
        /// </value>
        public double BedCost { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is bed; otherwise, <c>false</c>.
        /// </value>
        public bool IsBed { get; set; }

        /// <summary>
        /// Gets or sets the provider cost.
        /// </summary>
        /// <value>
        /// The provider cost.
        /// </value>
        public IEnumerable<ProviderCostModel> ProviderCost { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the AdmissionDate.
        /// </summary>
        /// <value>
        /// The AdmissionDate.
        /// </value>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the DischargeDate.
        /// </summary>
        /// <value>
        /// The DischargeDate.
        /// </value>
        public DateTime DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string ChargeCategoryName { get; set; }
        public string ModuleTypeName { get; set; }
    }
}
