﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class AdmissionTransferRequest
    {
        /// <summary>
        /// Gets or sets the admission transfer request id.
        /// </summary>
        [Key, Identity]
        public int AdmissionTransferRequestId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the doctor unit master id.
        /// </summary>
        public int? DoctorUnitMasterId { get; set; }
        /// <summary>
        /// Gets or sets the doctor unit master id.
        /// </summary>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        public Array? ChargeCategories { get; set; } = null;
        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        public int LocationId { get; set; }
        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        public int AdmissionChangeRequestTypeId { get; set; }
        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        public string? RequestComments { get; set; }
        /// <summary>
        /// Gets or sets the Rejected By.
        /// </summary>
        public int? RejectedBy { get; set; }

        /// <summary>
        /// Gets or sets the Rejected Date.
        /// </summary>
        public DateTime? RejectedDate { get; set; }

    }
}
