﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider document.
    /// </summary>
    public class ProviderDocument
    {
        /// <summary>
        /// Gets or sets the provider document id.
        /// </summary>
        [Key, Identity]
        public int ProviderDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        [IgnoreUpdate]
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the document name.
        /// </summary>
        public string DocumentName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the document type.
        /// </summary>
        public string DocumentType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the document url.
        /// </summary>
        public string DocumentUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        public DateTime UploadedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
