﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using System.Transactions;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;

    /// <inheritdoc />
    public class BirthCertificateService : IBirthCertificateService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IBirthCertificateService" />
        public BirthCertificateService(IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
        }

        public async Task<IEnumerable<BirthCertificateModel>> FetchAllAsync(BirthCertificateModel model)
        {
            var query = $@"select COUNT(*) OVER() AS ""TotalItems"",b.""BirthCertificateId"",b.""BirthCertificateNo"",b.""ChildName"",b.""DateOfBirth"" as ""BabyDateOfBirth"",
b.""TimeOfBirth"" as ""BabyTime"",b.""Sex"" as ""Babysex"",b.""PlaceOfBirth"",b.""AgeOfMotherAtMarriage"",b.""InformantsName"",b.""InformantsAddress"",p.""FullName"" as ""PatientName"",p.""UMRNo"",p.""Mobile"",b.""CreatedDate"",b.""ModifiedDate"",
a.""AdmissionId"",a.""AdmissionNo"",b.""BirthCertificateId"",ac.""FullName"" as ""CreatedByName"",
at.""FullName"" as ""ModifiedByName"" from ""BirthCertificate"" b
left join ""Admission"" a on a.""AdmissionId""=b.""AdmissionId""
left join ""Patient"" p on p.""PatientId""=b.""PatientId""
left join ""Account"" ac on ac.""AccountId"" = b.""CreatedBy""
left join ""Account"" at on at.""AccountId""=b.""ModifiedBy""
order by b.""BirthCertificateId"" desc";

            if (model.PageIndex != null && model.PageSize != null)
            {
                model.PageIndex = model.PageIndex > 0 ? model.PageIndex - 1 : model.PageIndex;
                query += $@" limit {model.PageSize} offset {model.PageSize * model.PageIndex}";
            }
            return await this.unitOfWork.Current.QueryAsync<BirthCertificateModel>(query);
        }
        public async Task<BirthCertificateModel> FetchBirthReportAsync(BirthCertificateModel model)
        {
            var where = $@" where 1=1 and";
            if (model.BirthCertificateId > 0)
            {
                where += $@" b.""BirthCertificateId""={model.BirthCertificateId}";
            }
            var query = $@"select COUNT(*) OVER() AS ""TotalItems"",b.""BabyWeight"",b.""TypeOfDelivery"",b.""MethodOfDelivery"",b.""DurationOfPregnancy"",
b.""NoOfChildBorn"",oc.""Name"" as ""OccupationName"",ed.""Name"" as ""EducationName"",p.""Religion"",p.""Zipcode"",
p.""State"",p.""StreetAddress"",p.""AddressLine2"",p.""City"",p.""State"",p.""PatientId"",pf.""FullName"" as ""FatherName"",pf.""Education"" as ""FatherEducation"",
pf.""Occupation"" as ""FatherOccupation"",pf.""OccupationDetails"" as ""FatherOccupationDetails"",
p.""Religion"",p.""Age"" as ""PatientAge"",b.""BirthCertificateId"",b.""BirthCertificateNo"",b.""ChildName"",b.""DateOfBirth"" as ""BabyDateOfBirth"",
b.""TimeOfBirth"" as ""BabyTime"",b.""Sex"" as ""Babysex"",b.""PlaceOfBirth"",b.""AgeOfMotherAtMarriage"",b.""InformantsName"",b.""InformantsAddress"",p.""FullName"" as ""PatientName"",p.""UMRNo"",p.""Mobile"",b.""CreatedDate"",b.""ModifiedDate"",
a.""AdmissionId"",a.""AdmissionNo"",b.""BirthCertificateId"",ac.""FullName"" as ""CreatedByName"",
at.""FullName"" as ""ModifiedByName"" from ""BirthCertificate"" b
left join ""Admission"" a on a.""AdmissionId""=b.""AdmissionId""
left join ""Patient"" p on p.""PatientId""=b.""PatientId""
left join ""Occupation"" oc on oc.""OccupationId""=p.""OccupationId""
left join ""Education"" ed on ed.""EducationId""=p.""EducationId""
left join ""PatientFamily"" pf on pf.""PatientId""=p.""PatientId"" and pf.""Relation""='Husband'
left join ""Account"" ac on ac.""AccountId"" = b.""CreatedBy""
left join ""Account"" at on at.""AccountId""=b.""ModifiedBy""
 {where}";


            return await this.unitOfWork.Current.QueryFirstOrDefaultAsync<BirthCertificateModel>(query);
        }

        public async Task<int> InsertAsync(BirthCertificateModel model)
        {
            var birthCertificate = new BirthCertificate
            {
                BirthCertificateNo = model.BirthCertificateNo,
                ChildName = model.ChildName,
                DateOfBirth = model.DateOfBirth,
                TimeOfBirth = model.TimeOfBirth,
                Sex = model.Sex,
                PlaceOfBirth = model.PlaceOfBirth,
                AgeOfMotherAtMarriage = model.AgeOfMotherAtMarriage,
                InformantsName = model.InformantsName,
                InformantsAddress = model.InformantsAddress,
                PatientId = model.PatientId,
                AdmissionId = model.AdmissionId,
                Active = true,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
                BabyWeight = model.BabyWeight,
                TypeOfDelivery = model.TypeOfDelivery,
                MethodOfDelivery = model.MethodOfDelivery,
                DurationOfPregnancy = model.DurationOfPregnancy,
                NoOfChildBorn = model.NoOfChildBorn
            };
            var response = await unitOfWork.BirthCertificates.InsertAsync(birthCertificate);
            //var patient = await this.unitOfWork.Patients.FindAsync(x => x.PatientId == model.PatientId);
            //patient.Salutation = patient.Salutation;
            //patient.FirstName = patient.FirstName;
            //patient.MiddleName = patient.MiddleName;
            //patient.LastName = patient.LastName;
            //patient.FullName = model.MotherName;
            //patient.FatherOrHusband = patient.FatherOrHusband;
            //patient.DateOfBirth = patient.DateOfBirth;
            //patient.Age = (short)model.PresentMotherAge;
            //patient.Gender = patient.Gender;
            //patient.MaritalStatus = patient.MaritalStatus;
            //patient.Email = patient.Email;
            //patient.Mobile = patient.Mobile;
            //patient.StreetAddress = model.MotherResidence;
            //patient.AddressLine2 = model.Village;
            //patient.City = patient.City;
            //patient.State = model.State;
            //patient.Zipcode = patient.Zipcode;
            //patient.CountryId = patient.CountryId;
            //patient.ModifiedBy = model.ModifiedBy;
            //patient.ModifiedDate = DateTime.UtcNow;
            //patient.AadharNo = patient.AadharNo;
            //patient.PatientReferredById = patient.PatientReferredById;
            //patient.ReferredByName = patient.ReferredByName;
            //patient.HWCPatientId = patient.HWCPatientId;
            //patient.Education = patient.Education;
            //patient.Occupation = patient.Occupation;
            //patient.Nationality = patient.Nationality;
            //patient.Religion = model.Religion;
            //patient.IdProofId = patient.IdProofId;
            //patient.IdProofValue = patient.IdProofValue;
            //patient.BloodGroup = patient.BloodGroup;
            //patient.PaymentStatus = patient.PaymentStatus;
            //patient.PayTypeId = patient.PayTypeId;
            //patient.PaymentNumber = patient.PaymentNumber;
            //patient.UMRNo = patient.UMRNo;
            //patient.TempPatient = patient.PaymentStatus;
            //patient.HowDidYouKnowId = patient.HowDidYouKnowId;
            //patient.EducationId = patient.EducationId;
            //patient.OccupationId = model.OccupationId;
            //patient.OccupationDetail = model.OccupationDetail;
            //var updated = await this.unitOfWork.Patients.UpdateAsync(patient);

            return response;

        }
    }
}