﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class DietGuidLinesModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int DietGuidLinesId { get; set; }
        public string DietGuidLinesName { get; set; }
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string ContentType { get; set; }
        public string PdfLink { get; set; }
        public int? DietTypeId { get; set; }
        public string DietTypeName { get; set; }
        public string DocumentUrl { get; set; }
        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        public float Size { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        public int? PageIndex { get; set; }
        public int? PageSize { get; set; }
        public string CreatedByName { get; set; }
        public string ModifiedByName { get; set; }
    }
    /// <summary>
    /// The patient document filter model.
    /// </summary>
    public class DocumentViewModel
    {

        /// <summary>
        /// gets or sets the base64.
        /// </summary>
        public string? Base64 { get; set; }

        /// <summary>
        /// gets or sets the DocumentUrl.
        /// </summary>
        public string? DocumentUrl { get; set; }

        /// <summary>
        /// gets or sets the FTP ErrorMessage.
        /// </summary>
        public string? ErrorMessage { get; set; }

    }
}
