﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The inventory product model.
    /// </summary>
    public class ProductModel
    {
        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the retail name.
        /// </summary>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the company id.
        /// </summary>
        public int CompanyId { get; set; } = 0;

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int? CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int? SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; } = 0;


        /// <summary>
        /// Gets or sets the purchase unit.
        /// </summary>
        public int PurchaseUnit { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit quantity.
        /// </summary>
        public int PurchaseUnitQuantity { get; set; }

        /// <summary>
        /// Gets or sets the sale unit.
        /// </summary>
        public int SaleUnit { get; set; }

        /// <summary>
        /// Gets or sets the sale unit quantity.
        /// </summary>
        public int SaleUnitQuantity { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is batch number.
        /// </summary>
        public bool IsBatchNumber { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is expiry.
        /// </summary>
        public bool IsExpiry { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        public string Tax { get; set; }

        /// <summary>
        /// Gets or sets the rack name.
        /// </summary>
        public string RackName { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit name.
        /// </summary>
        public string PurchaseUnitName { get; set; }

        /// <summary>
        /// Gets or sets the sale unit name.
        /// </summary>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is product expire.
        /// </summary>
        public bool IsProductExpire { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        public int SaleUnitQty { get; set; } = 0;

        /// <summary>
        /// Gets or sets the rol quantity.
        /// </summary>
        public int? RolQuantity { get; set; } = 0;

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the available quantity.
        /// </summary>
        public int AvailableQuantity { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the is get product id.
        /// </summary>
        public bool IsGetProductId { get; set; }

        /// <summary>
        /// Gets or sets the bulk product ids.
        /// </summary>
        public string BulkProductIds { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        public int? SupplierProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int? Quantity { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }


        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public double? Free { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the indent detail identifier.
        /// </summary>
        /// <value>
        /// The indent detail identifier.
        /// </value>
        public int? IndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the HSN code.
        /// </summary>
        /// <value>
        /// The HSN code.
        /// </value>
        public string HSNCode { get; set; }

        /// <summary>
        /// Gets or sets the available quantity.
        /// </summary>
        public int IssuedQuantity { get; set; }

        /// <summary>
        /// Gets or sets the requested quantity.
        /// </summary>
        /// <value>
        /// The requested quantity.
        /// </value>
        public int RequestedQuantity { get; set; }

        /// <summary>
        /// Gets or sets the search parameter.
        /// </summary>
        /// <value>
        /// The search parameter.
        /// </value>
        public string SearchParam { get; set; }

        /// <summary>
        /// Gets or sets the medication identifier.
        /// </summary>
        /// <value>
        /// The medication identifier.
        /// </value>
        public string MedicationId { get; set; }

        /// <summary>
        /// Gets or sets the suppliers.
        /// </summary>
        /// <value>
        /// The suppliers.
        /// </value>
        public string Suppliers { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is SGST.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is SGST; otherwise, <c>false</c>.
        /// </value>
        public bool IsSGST { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is igst.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is igst; otherwise, <c>false</c>.
        /// </value>
        public bool IsIGST { get; set; }

        /// <summary>
        /// Gets or sets the scheduled drug.
        /// </summary>
        /// <value>
        /// The scheduled drug.
        /// </value>
        public string ScheduledDrug { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is general item.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is general item; otherwise, <c>false</c>.
        /// </value>
        public bool IsGeneralItem { get; set; }

        /// <summary>
        /// Gets or sets the storage type identifier.
        /// </summary>
        /// <value>
        /// The storage type identifier.
        /// </value>
        public int? StorageTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product sub type identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product sub type identifier.
        /// </value>
        public int? PharmacyProductSubTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product type identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product type identifier.
        /// </value>
        public int? PharmacyProductTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the storage type.
        /// </summary>
        /// <value>
        /// The name of the storage type.
        /// </value>
        public string StorageTypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sub type.
        /// </summary>
        /// <value>
        /// The name of the sub type.
        /// </value>
        public string SubTypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [only consumable].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [only consumable]; otherwise, <c>false</c>.
        /// </value>
        public bool OnlyConsumable { get; set; }

        /// <summary>
        /// Gets or sets the potency.
        /// </summary>
        /// <value>
        /// The potency.
        /// </value>
        public string Potency { get; set; }

        /// <summary>
        /// Gets or sets the dosage.
        /// </summary>
        /// <value>
        /// The dosage.
        /// </value>
        public string Dosage { get; set; }

        /// <summary>
        /// Gets or sets the formula.
        /// </summary>
        /// <value>
        /// The formula.
        /// </value>
        public string Formula { get; set; }

        /// <summary>
        /// Gets or sets the strength.
        /// </summary>
        /// <value>
        /// The strength.
        /// </value>
        public string Strength { get; set; }

        /// <summary>
        /// Gets or sets the drug risk identifier.
        /// </summary>
        /// <value>
        /// The drug risk identifier.
        /// </value>
        public int? DrugRiskId { get; set; }

        /// <summary>
        /// Gets or sets the nabh category identifier.
        /// </summary>
        /// <value>
        /// The nabh category identifier.
        /// </value>
        public int? NABHCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the dosage type identifier.
        /// </summary>
        /// <value>
        /// The dosage type identifier.
        /// </value>
        public int? DosageTypeId { get; set; }

        /// <summary>
        /// Gets or sets the med frequency master identifier.
        /// </summary>
        /// <value>
        /// The med frequency master identifier.
        /// </value>
        public int? MedFrequencyMasterId { get; set; }

        /// <summary>
        /// Gets or sets the no of times.
        /// </summary>
        /// <value>
        /// The no of times.
        /// </value>
        public int? NoOfTimes { get; set; }

        /// <summary>
        /// Gets or sets the inventory expiry.
        /// </summary>
        /// <value>
        /// The inventory expiry.
        /// </value>
        public int? InventoryExpiry { get; set; }

        /// <summary>
        /// Gets or sets the formulation identifier.
        /// </summary>
        /// <value>
        /// The formulation identifier.
        /// </value>
        public int? FormulationId { get; set; }

        /// <summary>
        /// Gets or sets the med route identifier.
        /// </summary>
        /// <value>
        /// The med route identifier.
        /// </value>
        public int? MedRouteId { get; set; }

        /// <summary>
        /// Gets a value indicating whether [sale loose].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [sale loose]; otherwise, <c>false</c>.
        /// </value>
        public bool SaleLoose { get; set; }

        /// <summary>
        /// Gets or sets the fixed dose.
        /// </summary>
        /// <value>
        /// The fixed dose.
        /// </value>
        public double? FixedDose { get; set; }

        /// <summary>
        /// Gets or sets the alchohol interaction.
        /// </summary>
        /// <value>
        /// The alchohol interaction.
        /// </value>
        public string AlchoholInteraction { get; set; }

        /// <summary>
        /// Gets or sets the pregnancy interaction.
        /// </summary>
        /// <value>
        /// The pregnancy interaction.
        /// </value>
        public string PregnancyInteraction { get; set; }

        /// <summary>
        /// Gets or sets the expert advice.
        /// </summary>
        /// <value>
        /// The expert advice.
        /// </value>
        public string ExpertAdvice { get; set; }

        /// <summary>
        /// Gets or sets the common side effects.
        /// </summary>
        /// <value>
        /// The common side effects.
        /// </value>
        public string CommonSideEffects { get; set; }

        /// <summary>
        /// Gets or sets the medicine FAQ.
        /// </summary>
        /// <value>
        /// The medicine FAQ.
        /// </value>
        public string MedicineFaq { get; set; }

        /// <summary>
        /// Gets or sets the medicine interaction.
        /// </summary>
        /// <value>
        /// The medicine interaction.
        /// </value>
        public string MedicineInteraction { get; set; }

        /// <summary>
        /// Gets or sets the usage.
        /// </summary>
        /// <value>
        /// The usage.
        /// </value>
        public string Usage { get; set; }

        /// <summary>
        /// Gets or sets the name of the drug risk.
        /// </summary>
        /// <value>
        /// The name of the drug risk.
        /// </value>
        public string DrugRiskName { get; set; }

        /// <summary>
        /// Gets or sets the name of the nabh category.
        /// </summary>
        /// <value>
        /// The name of the nabh category.
        /// </value>
        public string NABHCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the dosage type.
        /// </summary>
        /// <value>
        /// The name of the dosage type.
        /// </value>
        public string DosageTypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the frequency.
        /// </summary>
        /// <value>
        /// The name of the frequency.
        /// </value>
        public string FrequencyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the formulation.
        /// </summary>
        /// <value>
        /// The name of the formulation.
        /// </value>
        public string FormulationName { get; set; }

        /// <summary>
        /// Gets or sets the name of the med route.
        /// </summary>
        /// <value>
        /// The name of the med route.
        /// </value>
        public string MedRouteName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [inventory item].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [inventory item]; otherwise, <c>false</c>.
        /// </value>
        public bool InventoryItem { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int? ModulesMasterId { get; set; }
    }
}
