﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary> The Radiology Value.</summary>
    public class RadiologyValueModel
    {
        /// <summary>Gets or sets the lab order value id.</summary>
        public int RadiologyValueId { get; set; }

        /// <summary>Gets or sets the name.</summary>
        public string? OrderCode { get; set; }

        /// <summary>Gets or sets the test.</summary>
        public string? Code { get; set; }

        /// <summary>Gets or sets the test.</summary>
        public string? Name { get; set; }

        /// <summary>Gets or sets the test.</summary>
        public string? Test { get; set; }

        /// <summary>Gets or sets the test.</summary>
        public int RadiologyId { get; set; }

        /// <summary>Gets or sets the created by.</summary>
        public int CreatedBy { get; set; }

        /// <summary>Gets or sets the created date.</summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>Gets or sets the modified by.</summary>
        public int? ModifiedBy { get; set; }

        /// <summary>Gets or sets the modified date.</summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the is assigned radiology value.
        /// </summary>
        public bool? IsAssignedRadiologyValue { get; set; }

        /// <summary>Gets or sets the total items.</summary>
        public int? TotalItems { get; set; }
    }
}
