﻿namespace Hims.Shared.EntityModels
{
    using System.Collections.Generic;

    /// <summary>The video call push notification to all devices model.</summary>
    public class VideoCallPushNotificationToAllDevicesModel
    {
        /// <summary>
        /// Gets or sets the device token.
        /// </summary>
        public IEnumerable<string> DeviceToken { get; set; } 

        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public string DeviceId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string DoctorName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Doctor Email.
        /// </summary>
        public string DoctorEmail { get; set; } = string.Empty;

        /// <summary>
        ///  Gets or sets the message.
        /// </summary>
        public string Message { get; set; } = string.Empty;
    }
}