﻿namespace Hims.Shared.Library.Enums
{
    /// <summary>
    /// The internal medicine.
    /// </summary>
    public enum OBEncounterType
    {
        /// <summary>
        /// The vitals.
        /// </summary>
        ProblemList = 1,

        /// <summary>
        /// The problem list.
        /// </summary>
        Vitals,

        /// <summary>
        /// The brief ros.
        /// </summary>
        BriefRos,

        /// <summary>
        /// The genetic screening.
        /// </summary>
        GeneticScreening,

        /// <summary>
        /// The infection history.
        /// </summary>
        InfectionHistory,

        /// <summary>
        /// The anc card closure.
        /// </summary>
        ANCCaredClosure,

        /// <summary>
        /// The breast examination.
        /// </summary>
        BreastExamination,

        /// <summary>
        /// The anc card closure.
        /// </summary>
        ANCCardGeneration,

        /// <summary>
        /// The complaints.
        /// </summary>
        Complaints,

        /// <summary>
        /// The complaints.
        /// </summary>
        OrderPrescription,

        /// <summary>
        /// The complaints.
        /// </summary>
        ObstetricExamination,

        /// <summary>
        /// The vaginal examination.
        /// </summary>
        VaginalExamination,

        /// <summary>The plan of management.</summary>
        PlanOfManagement,
       
        /// <summary>
        /// The drug history
        /// </summary>
        DrugHistory,
        /// <summary>
        /// The menstrual history
        /// </summary>
        MenstrualHistory,
        /// <summary>
        /// The other detail
        /// </summary>
        OtherDetail,
        

        /// <summary>
        /// The VTE Risk
        /// </summary>
        VTERisk,

        /// <summary>
        /// The birth history
        /// </summary>
        BirthHistory,

        /// <summary>
        /// The procedure form
        /// </summary>
        ProcedureForm,

        /// <summary>
        /// The sga Scanning
        /// </summary>
        SGAScanning,

        /// <summary>
        /// The surgeries
        /// </summary>
        Surgeries,

        /// <summary>
        /// The antinantal risk
        /// </summary>
        AntinantalRisk,

        /// <summary>
        /// The Vaccine
        /// </summary>
        Vaccine,
        /// <summary>
        /// The postnantal visit
        /// </summary>
        PostnantalVisit,
        /// <summary>
        /// The measure
        /// </summary>
        Measure,
        /// <summary>
        /// The general examination
        /// </summary>
        GeneralExamination,
        /// <summary>
        /// The breech
        /// </summary>
        Breech,
        /// <summary>
        /// The anc card
        /// </summary>
        AncCard,
        /// <summary>
        /// The covid
        /// </summary>
        Covid,
        /// <summary>
        /// The anaesthesia record
        /// </summary>
        AnaesthesiaRecord,
        /// <summary>
        /// The pre pregnancy
        /// </summary>
        PrePregnancyCounseling,
        
        /// <summary>
        /// The anaesthesia record
        /// </summary>
        Allergies,
        /// <summary>
        /// The family history
        /// </summary>
        FamilyHistory,
        /// <summary>
        /// The family history
        /// </summary>
        OutPatientManagement,
        /// <summary>
        /// The pre pregnancy plan
        /// </summary>
        PrePregnancyPlan,
        /// <summary>
        /// The special feature
        /// </summary>
        SpecialFeature,
        /// <summary>
        /// The referralForm feature
        /// </summary>
        ReferralForm,
        /// <summary>
        /// The referralForm feature
        /// </summary>
        RefferalOrder,
        /// <summary>
        /// The admission slip
        /// </summary>
        AdmissionSlip,
        /// <summary>
        /// The mother with epilepsy
        /// </summary>
        MotherWithEpilepsy,
        /// <summary>
        /// The external cephalic version
        /// </summary>
        ExternalCephalicVersion,
        /// <summary>
        /// The discharge summary
        /// </summary>
        DischargeSummary,


        /// <summary>
        /// The syndromes
        /// </summary>
        Syndromes,
        /// <summary>
        /// The syndromes
        /// </summary>
        OPManagement,
        /// <summary>
        /// The nurseAssessment
        /// </summary>
        NurseAssessment,
        /// <summary>
        /// The outside tests
        /// </summary>
        OutSideTests,
        /// <summary>
        /// The outside tests
        /// </summary>
        MeasureCommonData,
        /// <summary>
        /// The outside tests
        /// </summary>
        AncCardCloseCommonData,
        /// <summary>
        /// The neonatal assessment form
        /// </summary>
        NeonatalAssessmentForm,
        /// <summary>
        /// The neonatal assessment form
        /// </summary>
        ScanAppointmentDetails,
        /// <summary>
        /// The induction form
        /// </summary>
        InductionForm,
        /// <summary>
        /// The NormalDelivery form  
        /// </summary>
        NormalDeliveryForm,
        /// <summary>
        /// The LSCS
        /// </summary>
        LSCS,
        /// <summary>
        /// The Admission details
        /// </summary>
        AdmissionDetails,
        /// <summary>
        /// The IUFD
        /// </summary>
        IUFD ,
        /// <summary>
        /// The DoctorReview Form 
        /// </summary>    
        DoctorsReview,
        /// <summary>
        /// The Reminder 
        /// </summary> 
        Reminder,
        /// <summary>
        /// The Risk Category At Adm Form 
        /// </summary>    
        RiskCategoryAtAdm,
    }
}
