﻿namespace Hims.Shared.UserModels.Laboratory
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary> The chat.</summary>
    public class LabServicesModel
    {
        /// <summary>
        /// Gets or sets the lab service identifier.
        /// </summary>
        /// <value>
        /// The lab service identifier.
        /// </value>
        public int LabServicesId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking header identifier.
        /// </summary>
        /// <value>
        /// The lab booking header identifier.
        /// </value>
        public int? LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking detail identifier.
        /// </summary>
        /// <value>
        /// The lab booking detail identifier.
        /// </value>
        public int? LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab status identifier.
        /// </summary>
        /// <value>
        /// The lab status identifier.
        /// </value>
        public string LabStatus { get; set; }

        /// <summary>
        /// Gets or sets the lab report status identifier.
        /// </summary>
        /// <value>
        /// The lab report status identifier.
        /// </value>
        public bool? IsReportGenerated { get; set; }

        /// <summary>
        /// Gets or sets the sample collected identifier.
        /// </summary>
        /// <value>
        /// The sample collected identifier.
        /// </value>
        public bool? IsSampleCollected { get; set; }

        /// <summary>
        /// Gets or sets the lab report date identifier.
        /// </summary>
        /// <value>
        /// The lab report date identifier.
        /// </value>
        public DateTime? ReportDate { get; set; }

        /// <summary>
        /// Gets or sets the lab name identifier.
        /// </summary>
        /// <value>
        /// The lab name identifier.
        /// </value>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the lab code identifier.
        /// </summary>
        /// <value>
        /// The lab code identifier.
        /// </value>
        public string LabCode { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by name.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by name.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the lab header id identifier.
        /// </summary>
        /// <value>
        /// The lab header identifier.
        /// </value>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the unit.
        /// </summary>
        /// <value>
        /// The unit.
        /// </value>
        public int Unit { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ServiceOrder"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is main.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is main; otherwise, <c>false</c>.
        /// </value>
        public bool IsMain { get; set; }

        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        /// <value>
        /// The notes.
        /// </value>
        public string Notes { get; set; }

        public string TestName { get; set; }
        public string TestCode { get; set; }

        public string DiscountType { get; set; }
        public double? DiscountPercentage { get; set; }
        public double? DiscountAmount { get; set; }
        public double? Discount { get; set; }
    }
}
