﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The insurance for admission.
    /// </summary>
    public class InsuranceApproval
    {
        /// <summary>
        /// Gets or sets the insurance for admission id.
        /// </summary>
        [Key, Identity]
        public int InsuranceApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
        public int PatientInsuranceId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the expected amount.
        /// </summary>
        public double ExpectedAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the expected settlement date.
        /// </summary>
        public DateTime? ExpectedSettlementDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }
    }
}