﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The supplier product
    /// </summary>
    public class SupplierProduct
    {
        /// <summary>
        /// Gets or sets the supplier product id.
        /// </summary>
        [Key, Identity]
        public int SupplierProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double? PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double? Mrp { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
    }
}
