﻿using System.Collections.Generic;

namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.UserModels.ChargeManagement;

    /// <summary>
    /// The Bed Management Service
    /// </summary>
    public interface IChargeManagementService
    {
        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);

        /// <summary>
        /// Fetches the masters asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<MastersViewModel>> FetchMastersAsync();
    }
}
