﻿using System;

namespace Hims.Shared.UserModels.Vaccine
{
    /// <summary>
    /// The immunization history model.
    /// </summary>
    public class ImmunizationHistoryModel
    {
        /// <summary>
        /// Gets or sets the immunization history identifier.
        /// </summary>
        /// <value>
        /// The immunization history identifier.
        /// </value>
        public int ImmunizationHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the vaccine master identifier.
        /// </summary>
        /// <value>
        /// The vaccine master identifier.
        /// </value>
        public int VaccineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the order by.
        /// </summary>
        /// <value>
        /// The order by.
        /// </value>
        public string OrderBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the vaccine.
        /// </summary>
        /// <value>
        /// The name of the vaccine.
        /// </value>
        public string VaccineName { get; set; }


        /// <summary>
        /// Gets or sets the vaccine given by.
        /// </summary>
        /// <value>
        /// The vaccine given by.
        /// </value>
        public int? VaccineGivenBy { get; set; }


        /// <summary>
        /// Gets or sets the name of the vaccine given by.
        /// </summary>
        /// <value>
        /// The name of the vaccine given by.
        /// </value>
        public string VaccineGivenByName { get; set; }

        /// <summary>
        /// Gets or sets the vaccine given date.
        /// </summary>
        /// <value>
        /// The vaccine given date.
        /// </value>
        public DateTime? VaccineGivenDate { get; set; }

        /// <summary>
        /// Gets or sets the immunization ids.
        /// </summary>
        /// <value>
        /// The immunization ids.
        /// </value>
        public string ImmunizationIds { get; set; }

        /// <summary>
        /// Gets or sets the type of the allowed.
        /// </summary>
        /// <value>
        /// The type of the allowed.
        /// </value>
        public string AllowedType { get; set; }

        /// <summary>
        /// Gets or sets the allowed days.
        /// </summary>
        /// <value>
        /// The allowed days.
        /// </value>
        public int? AllowedDays { get; set; }
    }
}