﻿namespace Hims.Domain.Configurations
{
    /// <summary>
    /// The PayUConfiguration interface.
    /// </summary>
    public interface IPayUConfiguration
    {
        /// <summary>
        /// Gets the payment url.
        /// </summary>
        string PaymentURL { get; }

        /// <summary>
        /// Gets the key.
        /// </summary>
        string Key { get; }

        /// <summary>
        /// Gets the salt.
        /// </summary>
        string Salt { get; }

        /// <summary>
        /// Gets the service provider.
        /// </summary>
        string ServiceProvider { get; }

        /// <summary>
        /// Gets the success link.
        /// </summary>
        string SuccessLink { get; }

        /// <summary>
        /// Gets the failure link.
        /// </summary>
        string FailureLink { get; }

        /// <summary>
        /// Gets the Redirect success link.
        /// </summary>
        string RedirectSuccessLink { get; }

        /// <summary>
        /// Gets the Redirect failure link.
        /// </summary>
        string RedirectFailureLink { get; }

        /// <summary>
        /// Gets the auth header.
        /// </summary>
        string AuthHeader { get; }

        /// <summary>
        /// Gets the PayUUrl
        /// </summary>
        string PayUUrl { get; }

        /// <summary>
        /// Gets the payout oauth url.
        /// </summary>
        string PayoutOauthURL { get; }

        /// <summary>
        /// Gets the client id
        /// </summary>
        string ClientId { get; }

        /// <summary>
        /// Gets the payout merchant id
        /// </summary>
        string PayoutMerchantId { get; }

        /// <summary>
        /// Gets the web hooks.
        /// </summary>
        string WebHooks { get; }

        /// <summary>
        /// Gets or sets the authorization key.
        /// </summary>
        string AuthorizationKey { get; set; }
    }
}
