﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class Admission
    {
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        [Key, Identity]
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string AdmissionNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        public DateTime AdmissionDate { get; set; }

        public DateTime? ExpectedDischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the admission time.
        /// </summary>
        public TimeSpan? AdmissionTime { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? BedId { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the is discharged.
        /// </summary>
        public bool? IsDischarged { get; set; }

        /// <summary>
        /// Gets or sets the is maternity.
        /// </summary>
        public bool? IsMaternity { get; set; }

        /// <summary>
        /// Gets or sets the babys birth date.
        /// </summary>
        public DateTime? BabysBirthDate { get; set; }

        /// <summary>
        /// Gets or sets the babys birth time.
        /// </summary>
        public TimeSpan? BabysBirthTime { get; set; }

        /// <summary>
        /// Gets or sets the babys surgery type.
        /// </summary>
        public int? BabysSurgeryType { get; set; }

        /// <summary>
        /// Gets or sets the babys gender.
        /// </summary>
        public char? BabysGender { get; set; }

        /// <summary>
        /// Gets or sets the babys fathers name.
        /// </summary>
        public string? BabysFathersName { get; set; }

        /// <summary>
        /// Gets or sets the babys fathers name.
        /// </summary>
        public string? BabysMothersAdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the ready for discharge.
        /// </summary>
        public bool? ReadyforDischarge { get; set; }

        /// <summary>
        /// Gets or sets the admission notes.
        /// </summary>
        public string? AdmissionNotes { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the surgery type id.
        /// </summary>
        public int? SurgeryTypeId { get; set; }

        /// <summary>
        /// Gets or sets the attendant name.
        /// </summary>
        public string? AttendantName { get; set; }

        /// <summary>
        /// Gets or sets the attendant contact no.
        /// </summary>
        public string? AttendantContactNo { get; set; }

        /// <summary>
        /// Gets or sets the attendant relation with patient.
        /// </summary>
        public string? AttendantRelationWithPatient { get; set; }

        /// <summary>
        /// Gets or sets the Discharged by.
        /// </summary>
        public int? DischargedBy { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the is converted from op to ip.
        /// </summary>
        public bool? IsConvertedFromOPtoIp { get; set; }

        /// <summary>
        /// Gets or sets the patient priority identifier.
        /// </summary>
        /// <value>
        /// The patient priority identifier.
        /// </value>
        public int? PatientPriorityId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the case type id.
        /// </summary>
        /// <value>
        /// The name of the case type id.
        /// </value>
        public int? CaseTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        /// <value>
        /// The name of the pay type id.
        /// </value>
        public int? AdmissionPayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company Id.
        /// </summary>
        /// <value>
        /// The name of the insurance company Id.
        /// </value>
        public int? InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the referral doctor Id.
        /// </summary>
        /// <value>
        /// The name of the referral doctor Id.
        /// </value>
        public int? ReferralDoctorId { get; set; }
        /// <summary>
        /// Gets or sets the patient organization.
        /// </summary>
        /// <value>
        /// The patient organization.
        /// </value>
        public string BedAssociatedData { get; set; }
        /// <summary>
        /// Gets or sets the patient organization.
        /// </summary>
        /// <value>
        /// The patient organization.
        /// </value>
        public string NRIData { get; set; }
        /// <summary>
        /// Gets or sets the patient organization.
        /// </summary>
        /// <value>
        /// The patient organization.
        /// </value>
        public string SurrogacyData { get; set; }
        /// <summary>
        /// Gets or sets the patient organization.
        /// </summary>
        /// <value>
        /// The patient organization.
        /// </value>
        public string EmergencyInfo { get; set; }

        /// <summary>
        /// Gets or sets the tpa identifier.
        /// </summary>
        /// <value>
        /// The tpa identifier.
        /// </value>
        public int TpaId { get; set; }

        /// <summary>
        /// Gets or sets the patient organization.
        /// </summary>
        /// <value>
        /// The patient organization.
        /// </value>
        public string? PatientOrganization { get; set; }

        /// <summary>
        /// Gets or sets the doctor unit master identifier.
        /// </summary>
        /// <value>
        /// The doctor unit master identifier.
        /// </value>
        public int DoctorUnitMasterId { get; set; }

        /// <summary>
        /// Gets or sets the current room identifier.
        /// </summary>
        /// <value>
        /// The current room identifier.
        /// </value>
        public int? CurrentRoomId { get; set; }

        public int? CounsellingId { get; set; }
    }
}
