﻿namespace Hims.Domain.Entities.Inventory
{
    using Hims.Shared.Dapper.Attributes;   
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The inventory ware house user.
    /// </summary>
    public class InventoryWareHouseUser
    {
        /// <summary>
        /// Gets or sets the inventory ware house user identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house user identifier.
        /// </value>
        [Key, Identity]
        public int InventoryWareHouseUserId { get; set; }

        /// <summary>
        /// Gets or sets the inventory ware house identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house identifier.
        /// </value>
        public int InventoryWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the account identifier.
        /// </summary>
        /// <value>
        /// The account identifier.
        /// </value>
        public int AccountId { get; set; }
    }
}
