﻿namespace Hims.Domain.Entities.Labs
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab booking timeline.
    /// </summary>
    public class LabBookingTimeLine
    {
        /// <summary>
        /// Gets or sets the lab booking time line identifier.
        /// </summary>
        /// <value>
        /// The lab booking time line identifier.
        /// </value>
        [Key,Identity]
        public int LabBookingTimeLineId { get; set; }

        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking status identifier.
        /// </summary>
        /// <value>
        /// The lab booking status identifier.
        /// </value>
        public int LabBookingStatusId { get; set; }


        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the commented by.
        /// </summary>
        /// <value>
        /// The commented by.
        /// </value>
        public int CommentedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int? NewLabBookingDetailId { get; set; }
    }
}
