﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities.Labs
{
    /// <summary>
    /// The lab sample collection detail.
    /// </summary>
    public class LabSampleCollectionDetail
    {
        /// <summary>
        /// Gets or sets the lab sample collection detail identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection detail identifier.
        /// </value>
        [Key, Identity]
        public int LabSampleCollectionDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample collection identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection identifier.
        /// </value>
        public int LabSampleCollectionId { get; set; }

        /// <summary>
        /// Gets or sets the sub sample collected by.
        /// </summary>
        /// <value>
        /// The sub sample collected by.
        /// </value>
        public int? SubSampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the sub collection date.
        /// </summary>
        /// <value>
        /// The sub collection date.
        /// </value>
        public DateTime? SubCollectionDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [sub is barcode generated].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [sub is barcode generated]; otherwise, <c>false</c>.
        /// </value>
        public bool SubIsBarcodeGenerated { get; set; }

        /// <summary>
        /// Gets or sets the sub barcode generated by.
        /// </summary>
        /// <value>
        /// The sub barcode generated by.
        /// </value>
        public int? SubBarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the sub barcode date.
        /// </summary>
        /// <value>
        /// The sub barcode date.
        /// </value>
        public DateTime? SubBarcodeDate { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the sample.
        /// </summary>
        /// <value>
        /// The name of the sample.
        /// </value>
        public string SampleName { get; set; }

        /// <summary>
        /// Gets or sets the lab booking status identifier.
        /// </summary>
        /// <value>
        /// The lab booking status identifier.
        /// </value>
        public int? LabBookingStatusId { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the uncollect comment.
        /// </summary>
        /// <value>
        /// The uncollect comment.
        /// </value>
        public string UncollectComment { get; set; }
    }
}
