﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class PediatricEncounter
    {
        /// <summary>
        /// Gets or Sets the pediatric Encounter
        /// </summary>
        [Key, Identity]
        public int PediatricEncounterId { get; set; }
        /// <summary>
        /// Gets or Sets the appointment id
        /// </summary>
        public int? AppointmentId { get; set; }
        /// <summary>
        /// Gets or Sets the patient id
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or Sets the pediatric encounter date
        /// </summary>
        public DateTime PediatricEncounterDate { get; set; }
        /// <summary>
        /// Gets or Sets the active
        /// </summary>
        /// 
        public bool Active { get; set; }
        /// <summary>
        /// Gets or Sets the created by
        /// </summary>

        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or Sets the created date
        /// </summary>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or Sets the modified by
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or Sets the modified date
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or Sets the admission id
        /// </summary>
        public int? AdmissionId { get; set; }
        /// <summary>
        /// Gets or Sets Measurements
        /// </summary>
        public string Measurements { get; set; }
        /// <summary>
        /// Gets or Sets NeonatalRisk.
        /// </summary>
        public string NeonatalRisk { get; set; }
        /// <summary>
        /// Gets or Sets PediatricRisk.
        /// </summary>
        public string PediatricRisk { get; set; }
        /// <summary>
        /// Gets or Sets Syndrome.
        /// </summary>
        public string Syndrome { get; set; }
        /// <summary>
        /// Gets or Sets Syndrome.
        /// </summary>
        /// 
        public string ClinicalExamination { get; set; }
        /// <summary>
        /// Gets or Sets Syndrome.
        /// </summary>
        public string DownSyndromeFollowUp { get; set; }

        /// <summary>
        /// Gets or Sets High Risk Intial.
        /// </summary>
        public string HighRiskIntial { get; set; }
        /// <summary>
        /// Gets or Sets Pediatric Guide.
        /// </summary>
        public string PediatricGuide { get; set; }
        /// <summary>
        /// Gets or Sets Order Prescription.
        /// </summary>
        public string OrderPrescription { get; set; }
        /// <summary>
        /// Gets or Sets Order Allergies.
        /// </summary>
        public string Allergies { get; set; }

        
        /// <summary>
        /// Gets or Sets ReferalOrder.
        /// </summary>
        public string RefferalOrder { get; set; }

        /// <summary>
        /// Gets or sets the vaccine detail.
        /// </summary>
        /// <value>
        /// The vaccine detail.
        /// </value>
        public string VaccineDetail { get; set; }
        /// <summary>
        /// Gets or Sets MChat
        /// </summary>
        public string MChat { get; set; }
       
      
        /// <summary>
        /// Gets or Sets Special Features
        /// </summary>
        public string SpecialFeatures { get; set; }
        /// <summary>
        /// Gets or sets the diagnosis order.
        /// </summary>
        /// <value>
        /// The diagnosis order.
        /// </value>
        public string DiagnosisOrder { get; set; }
        /// <summary>
        /// Gets or sets thenext visit order.
        /// </summary>
        /// <value>
        /// The next visit order.
        /// </value>
        public string NextVisitOrder { get; set; }
        /// <summary>
        /// Gets or sets measure common data.
        /// </summary>
        /// <value>
        /// The Measure Common Data.
        /// </value>
        public string MeasureCommonData { get; set; }
        /// <summary>
        /// Gets or sets ReminderForm.
        /// </summary>
        /// <value>
        /// The ReminderForm.
        /// </value>
        public string Reminder { get; set; }
    }
       
    }

