﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities.Pharmacy
{

    /// <summary>
    /// The pharnacy inpatient return.
    /// </summary>
    public class PharmacyInPatientReturn
    {
        /// <summary>
        /// Gets or sets the pharmacy in patient return identifier.
        /// </summary>
        /// <value>
        /// The pharmacy in patient return identifier.
        /// </value>
        [Key,Identity]
        public long PharmacyInPatientReturnId { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy issue detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issue detail identifier.
        /// </value>
        public int PharmacyIssueDetailId { get; set; }
        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        /// <value>
        /// The return quantity.
        /// </value>
        public int ReturnQuantity { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the accepted by.
        /// </summary>
        /// <value>
        /// The accepted by.
        /// </value>
        public int? AcceptedBy { get; set; }
        /// <summary>
        /// Gets or sets the accepted date.
        /// </summary>
        /// <value>
        /// The accepted date.
        /// </value>
        public DateTime? AcceptedDate { get; set; }
    }
}
