﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.ConsultationType;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IConsultationTypeService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);
        

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(InsertModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="visitTypeId">
        /// The specialization id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int visitTypeId);


        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="visitTypeId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindNameByConsultationTypeId(int visitTypeId);
    }
}
