﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    using Hims.Shared.UserModels.PediatricGraphs;

    /// <summary>
    /// The Pediatric Chart Service interface.
    /// </summary>
    public interface IPediatricChartService
    {
        /// <summary>
        /// Modifies the pediatric authority.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyPediatricAuthority(PediatricChartAuthorityModel model);

        /// <summary>
        /// Fetches the authority asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PediatricChartAuthorityModel>> FetchAuthorityAsync(PediatricChartAuthorityModel model);

        /// <summary>
        /// Changes the authority status asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ChangeAuthorityStatusAsync(PediatricChartAuthorityModel model);

        /// <summary>
        /// Fetches the type of the pediatric chart.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<PediatricChartTypeModel>> FetchPediatricChartType();

        /// <summary>
        /// Fetches the pediatric display asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<PediatricBaseDisplayModel>> FetchPediatricDisplayAsync();

        /// <summary>
        /// Fetches the age wise data asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PediatricAgeWiseDataModel>> FetchAgeWiseDataAsync(PediatricAgeWiseDataModel model);

        /// <summary>
        /// Fetches the age wise data z score asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PediatricAgeWiseDataZScoreModel>> FetchAgeWiseDataZScoreAsync(PediatricAgeWiseDataZScoreModel model);
    }
}
