﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Hims.Shared.EntityModels;
    using Hims.Shared.Library.Enums;
    using Hims.Shared.Library.Helpers;
    using Hims.Shared.UserModels.PediatricEncounter;
    //using Ob = Hims.Shared.UserModels.OBEncounter;
    using pediatric = Shared.UserModels.PediatricEncounter;
    using pediatricEncounter = Shared.UserModels.PediatricEncounter;
    /// The InternalMedicineService interface.
    /// </summary>
    public interface IPediatricEncounterService
    {
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<PediatricEncounterModel> FindAsync(int appointmentId, bool isAdmission);


        /// <summary>
        /// The add ob encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAsync(pediatric.InsertModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAsync(pediatric.InsertModel model);

        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="type">The type.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<pediatric.PediatricEncounterResource> FindDashboardAsync(int appointmentId,PediatricEncounterType type, bool isAdmission);


        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        // Task<PediatricEncounterFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);
        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<PediatricEncounterFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);
        Task<int> FetchVisitNoAsync(int patientId);

        /// <summary>
        /// Fetches the pediatric measurement history asynchronous.
        /// </summary>
        /// <param name="patientId">The patient identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<PediatricMeasurmentModel>> FetchPediatricMeasurementHistoryAsync(int patientId);
    }
}
