﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Hims.Shared.UserModels.AppointmentCheck;

    /// <inheritdoc />
    public class AppointmentCheckService : IAppointmentCheckService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IBedService" />
        public AppointmentCheckService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<IEnumerable<FetchModel>> FetchAsync(FetchPayload model)
        {
            var query = $@"SELECT AC.""FullName"" ""UserName"",R.""RoleName"",ACP.""AppointmentId"", ""Action"", ""Date"" FROM ""AppointmentCheckPoints"" ACP 
                            left join ""Account"" AC on AC.""AccountId""=ACP.""CreatedBy""
                            left join ""Role"" R on R.""RoleId""=AC.""RoleId""
                            WHERE ACP.""AppointmentId"" = {model.AppointmentId}";
            var data = await this.unitOfWork.Current.QueryAsync<FetchModel>(query);
            return data;
        }

        public async Task<int> InsertAsync(InsertModel model)
        {
            var data = new AppointmentCheckPoints
            {
                Action = model.Action,
                AppointmentId = model.AppointmentId,
                CreatedBy = model.CreatedBy,
                ExternalUserId = model.UserId
            };

           var response = await this.unitOfWork.AppointmentCheckPoints.InsertAsync(data);
            return response;
        }
    }
}