﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;

    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.PediatricGraphs;

    /// <inheritdoc />
    public class DenverChartService : IDenverChartService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IIdProofService" />
        public DenverChartService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public Task<IEnumerable<DenverChartModel>> FetchAllAsync(DenverChartModel model)
        {
            throw new NotImplementedException();
        }

        public async Task<IEnumerable<DenverChartModel>> FetchByAppointmentIdAsync(DenverChartModel model)
        {
            var where = "where 1=1 ";
            if (model.AppointmentId > 0)
            {
                where += $@" and dc.""AppointmentId"" = {model.AppointmentId}";
            }
            var query = $@"SELECT dc.""ItemName"" ,dc.""DateOfVisit"", dc.""Comments"",dc.""Question"", dc.""AppointmentId"", dc.""DenverChartData"",dc.""CreatedDate""
	                            FROM ""Denverchart"" dc
	                            {where} ";

            return await this.unitOfWork.Current.QueryAsync<DenverChartModel>(query);
        }

        public async Task<int> InsertAsync(DenverChartModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""Denverchart"" where ""AppointmentId"" = {model.AppointmentId}");
            if (checkIf > 0)
            {
                var sectionDetails = await this.unitOfWork.Denvercharts.FindAsync(m => m.AppointmentId == model.AppointmentId);

                sectionDetails.DenverChartData = model.DenverChartData;
                sectionDetails.Question = model.Question;
                return await this.unitOfWork.Denvercharts.UpdateAsync(sectionDetails);
            }
            var denver = new Denverchart
            {
                ItemName = model.ItemName,
                DateOfVisit = model.DateOfVisit,
                Comments = model.Comments,
                CreatedBy = model.CreatedBy,
                Active = true,
                CreatedDate = DateTime.Now,
                AppointmentId = model.AppointmentId,
                DenverChartData = model.DenverChartData,
                Question = model.Question,
            };
            return await this.unitOfWork.Denvercharts.InsertAsync(denver);

        }

        //public async Task<int> UpdateAsync(DenverChartModel model)
        //{
        //    //var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""AppointmentId"") FROM ""Denverchart"" WHERE  ""AppointmentId"" = {model.AppointmentId}");
        //    //if (checkIf > 0)
        //    //{
        //    //    return -1;
        //    //}

        //    //var sectionDetails = await this.unitOfWork.Denvercharts.FindAsync(m => m.AppointmentId == model.AppointmentId);

        //    //sectionDetails.DenverChartData = model.DenverChartData;
        //    //sectionDetails.Question = model.Question;
        //    //return await this.unitOfWork.Denvercharts.UpdateAsync(sectionDetails);
        //    return 0;
        //}
    }
}
